;***********************************************************************
;*                                                                     *
;* DSTORM.ASP  (C) 1990 DATASTORM TECHNOLOGIES, INC.                   *
;*                                                                     *
;* An ASPECT script for logging on to the DATASTORM BBS.               *
;*                                                                     *
;***********************************************************************
;
define DSTORM_ENTRY "1"             ; change this to the appropriate dialing
                                    ; directory entry number for DATASTORM
                                    ;
string first_name                   ; declare string variables
string last_name
string my_passwrd

proc main                           ; declare main procedure
    clear                           ; clear the screen
    box 0 15 9 60 14                ; paint a box
    atsay 2 17 14 "Logging onto the DATASTORM BBS..."
    atsay 4 17 14 "Please enter your first name: "
    atget 4 47 15 12 first_name     ; prompt for first name
    atsay 5 17 14 "Please enter your last name: "
    atget 5 47 15 12 last_name      ; prompt for last name
    atsay 7 17 14 "Please enter your password: "
    matget 7 47 15 8 my_passwrd     ; masked atget for password
    emulate ansi                    ; set ANSI terminal emulation
    if not fromddir           		; dial only if not from a
       dial DSTORM_ENTRY            ; Dialing Directory entry
    endif
    pause 2                   		; allow time for modem connect
    set txpace 50                   ; set character pacing to 50 ms
    log open "newbbs.log"           ; open a log file
    transmit "^M"                   ; send a carriage return
    waitfor "name?"		            ; wait for "First name?" prompt
    log suspend                     ; suspend the log file
    transmit first_name	            ; send your first name
    transmit "^M"                   ; follow with a carriage return
    waitfor "name?"		            ; wait for "Last name?" prompt
    transmit last_name	            ; send your last name
    transmit "^M"                   ; follow with a carriage return
    waitfor "correct?"              ; wait for verification prompt
    transmit "Y"                    ; verify with a "Y" character
    waitfor "password:"	            ; wait for password prompt
    transmit my_passwrd	            ; send your password
    transmit "^M"                   ; follow it with a carriage return
    log resume                		; continue the log file
    waitfor "-Press Any Key-"       ; wait for end of messages
    log suspend                     ; suspend the log file again
    transmit "^M"                   ; send carriage return to continue
    pause 2                         ; wait two seconds
    log resume                      ; continue the log file
    transmit "1^M"		            ; select item #1 from list
    waitfor "<CR> to exit"          ; wait for end of quote of the day
    log close                       ; close log file
    transmit "^M"                   ; send carriage return to return to
endproc                             ; main menu.  End of main procedure
