;***********************************************************************
;*                                                                     *
;* INCLUDE.ASP  (C) 1990 DATASTORM TECHNOLOGIES, INC.                  *
;*                                                                     *
;* An ASPECT header file containing definitions of video display       *
;* attributes, boolean variables, and special keys.  The color         *
;* definitions are composed of a foreground color and a background     *
;* color, while the special keys are the actual scan codes returned    *
;* when a key is pressed.                                              *
;***********************************************************************

;***********************************************************************
;* The following macros define the values used to create video display *
;* attributes.  To calculate an attribute value, multiply the          *
;* background color value by 256 and then add the foreground color.    *
;* To cause the foreground to blink, add 128 to the calculated value.  *
;*                                                                     *
;* The macro setvattr can be used to initialize a variable in the      *
;* in the following manner:                                            *
;*                                                                     *
;* integer x                                                           *
;* setvattr &x WHITE BLUE NOBLINK                                      *
;*                                                                     *
;* This defines the variable x as an attribute with a WHITE foreground *
;* on a BLUE background.  Note that this macro can only be used within *
;* the body of a procedure.  UNDERLINE and LTULINE may be used in      *
;* place of BLUE and LTBLUE on monochrome monitors.                    *
;***********************************************************************

define setvattr call mkvattr with

proc mkvattr
intparm attrvar, foreground, background, blinking
   attrvar = (background << 4) | foreground | blinking
endproc

define BLACK       0
define BLUE        1
define GREEN       2
define CYAN        3
define RED         4
define MAGENTA     5
define BROWN       6
define LTGREY      7

define GREY        8
define LTBLUE      9
define LTGREEN    10
define LTCYAN     11
define LTRED      12
define LTMAGENTA  13
define YELLOW     14
define WHITE      15

define UNDERLINE   1
define LTULINE     9

define NOBLINK     0
define BLINK     128

;***********************************************************************
;* Below are the definitions for Boolean variables and special         *
;* keys.                                                               *
;*                                                                     *
;***********************************************************************

define TRUE        1
define FALSE       0

define F1          0x3B00
define F2          0x3C00
define F3          0x3D00
define F4          0x3E00
define F5          0x3F00
define F6          0x4000
define F7          0x4100
define F8          0x4200
define F9          0x4300
define F10         0x4400
define F11         0x8500
define F12         0x8600

define HOME_KEY    0x4700
define END         0x4F00
define PG_UP       0x4900
define PG_DN       0x5100
define INS         0x5200
define DEL         0x5300

define CUR_LT      0x4B00
define CUR_RT      0x4D00
define CUR_DN      0x5000
define CUR_UP      0x4800

