;***********************************************************************
;*                                                                     *
;*  REMOTE.ASP  COPYRIGHT (C) 1990 DATASTORM TECHNOLOGIES, INC.        *
;*                                                                     *
;*  Purpose  : This ASPECT module illustrates a simple way to cause    *
;*     remote execution of a local script file.  This provides an      *
;*     alternative to sending several remote commands separately where *
;*     each command would require separate compilation before it could *
;*     be executed.  The file you send can be in source or compiled    *
;*     form.  The name for the file received and executed at the       *
;*     remote machine is defined in REMFILE below.                     *
;*                                                                     *
;*     You could easily have a local script interact with the script   *
;*     being executed remotely using RGET or WAITFOR commands for      *
;*     timing or branching to specific tasks.  You may also want to    *
;*     consider deleting the script from the remote upon completion of *
;*     its execution.  This could easily be accomplished by modifying  *
;*     this script to WAITFOR a response from the remote script which  *
;*     indicates that it has finished executing, and then issuing a    *
;*     remote command such as "^Ddos `"del $ASP_TMP.*`"^M".            *
;*                                                                     *
;*  Remember : The remote machine MUST have Remote Commands set ON in  *
;*     its General Options setup screen.                               *
;*                                                                     *
;***********************************************************************

define REMFILE "$ASP_TMP"              ; filename received by remote

proc main
   string filename,xmitfile,xmitstr
   integer extndx

   vidsave 0
   box 4 18 18 60 14
   atsay 5 24 15 "REMOTE SCRIPT EXECUTION FACILITY"
   atsay 6 19 14 "-----------------------------------------"
   atsay 8 20 15 "Enter the ASPECT filename:"
   atget 8 47 112 12 filename
   isfile filename
   if failure
      sound 220 10
      atsay 10 20 15 "File not found..."
      pause 3
   else
      find filename "." extndx
      substr xmitfile filename extndx 4
      strupr xmitfile
      strfmt xmitfile "%s%s" REMFILE xmitfile
      atsay 10 20 15 "Sending script file to remote..."
      strfmt xmitstr "^Dgetfile xmodem `"%s`"^M" xmitfile
      transmit xmitstr
      atsay 12 20 15 "Pausing for remote compilation..."
      pause 5
      sendfile xmodem filename
      if failure
         sound 220 20
         atsay 14 20 15 "Error sending file to remote"
         pause 3
      else
         pause 3
         atsay 14 20 15 "Sending EXECUTE command sequence..."
         strfmt xmitstr "^Dexecute `"%s`"^M" xmitfile
         transmit xmitstr
         pause 3
         sound 440 20
         atsay 16 20 15 "Operation completed -- Press any key"
         keyget
      endif
   endif
   vidrest 0
endproc


